import bpy
from bpy.types import Operator
from ....libs.functions.basics import deselect_all_objects, set_active_object
from ....libs.functions.get_common_vars import get_common_vars



class FLUIDLAB_OT_ff_forces_particles_add(Operator):
    bl_idname = "fluidlab.forces_particles_add"
    bl_label = "Add Force"
    bl_description = "Add Mesh Force"
    bl_options = {'REGISTER', 'UNDO'}


    def execute(self, context):

        previous_selection = context.selected_objects
        previous_active = context.active_object

        fluid_groups = get_common_vars(context, get_fluid_groups=True)

        active_group = fluid_groups.active
        if not active_group:
            print("no acrive_group!")
            return {'CANCELLED'}

        emitters_list = active_group.emitters
        if emitters_list.is_void:
            print("emitters list is void!")
            return {'CANCELLED'}

        emitter_ob = emitters_list.get_current_emitter

        deselect_all_objects(context)
        set_active_object(context, emitter_ob)
        emitter_ob.select_set(True)

        psys = emitter_ob.particle_systems.active
        psys_settings = psys.settings
        psys_settings.force_field_1.type = 'TURBULENCE'

        psys_settings.use_self_effect = True
        psys_settings.effector_amount = 15

        if previous_active:
            set_active_object(context, previous_active)

        deselect_all_objects(context)
        if previous_selection:
            for obj in previous_selection:
                obj.select_set(True)

        return {'FINISHED'}